<?php
namespace Temando\Shipping\ViewModel\Order\Location;

/**
 * Proxy class for @see \Temando\Shipping\ViewModel\Order\Location
 */
class Proxy extends \Temando\Shipping\ViewModel\Order\Location implements \Magento\Framework\ObjectManager\NoninterceptableInterface
{
    /**
     * Object Manager instance
     *
     * @var \Magento\Framework\ObjectManagerInterface
     */
    protected $_objectManager = null;

    /**
     * Proxied instance name
     *
     * @var string
     */
    protected $_instanceName = null;

    /**
     * Proxied instance
     *
     * @var \Temando\Shipping\ViewModel\Order\Location
     */
    protected $_subject = null;

    /**
     * Instance shareability flag
     *
     * @var bool
     */
    protected $_isShared = null;

    /**
     * Proxy constructor
     *
     * @param \Magento\Framework\ObjectManagerInterface $objectManager
     * @param string $instanceName
     * @param bool $shared
     */
    public function __construct(\Magento\Framework\ObjectManagerInterface $objectManager, $instanceName = '\\Temando\\Shipping\\ViewModel\\Order\\Location', $shared = true)
    {
        $this->_objectManager = $objectManager;
        $this->_instanceName = $instanceName;
        $this->_isShared = $shared;
    }

    /**
     * @return array
     */
    public function __sleep()
    {
        return ['_subject', '_isShared', '_instanceName'];
    }

    /**
     * Retrieve ObjectManager from global scope
     */
    public function __wakeup()
    {
        $this->_objectManager = \Magento\Framework\App\ObjectManager::getInstance();
    }

    /**
     * Clone proxied instance
     */
    public function __clone()
    {
        $this->_subject = clone $this->_getSubject();
    }

    /**
     * Get proxied instance
     *
     * @return \Temando\Shipping\ViewModel\Order\Location
     */
    protected function _getSubject()
    {
        if (!$this->_subject) {
            $this->_subject = true === $this->_isShared
                ? $this->_objectManager->get($this->_instanceName)
                : $this->_objectManager->create($this->_instanceName);
        }
        return $this->_subject;
    }

    /**
     * {@inheritdoc}
     */
    public function hasDeliveryLocation(\Magento\Sales\Api\Data\OrderInterface $order)
    {
        return $this->_getSubject()->hasDeliveryLocation($order);
    }

    /**
     * {@inheritdoc}
     */
    public function getDeliveryLocationTitle(\Magento\Sales\Api\Data\OrderInterface $order)
    {
        return $this->_getSubject()->getDeliveryLocationTitle($order);
    }

    /**
     * {@inheritdoc}
     */
    public function getBillingAddressHtml(\Magento\Sales\Api\Data\OrderInterface $order)
    {
        return $this->_getSubject()->getBillingAddressHtml($order);
    }

    /**
     * {@inheritdoc}
     */
    public function getShippingAddressHtml(\Magento\Sales\Api\Data\OrderInterface $order)
    {
        return $this->_getSubject()->getShippingAddressHtml($order);
    }

    /**
     * {@inheritdoc}
     */
    public function getDeliveryLocationAddressHtml(\Magento\Sales\Api\Data\OrderInterface $order)
    {
        return $this->_getSubject()->getDeliveryLocationAddressHtml($order);
    }
}
