<?php
namespace Temando\Shipping\Rest\EntityMapper\FulfillmentResponseMapper;

/**
 * Proxy class for @see \Temando\Shipping\Rest\EntityMapper\FulfillmentResponseMapper
 */
class Proxy extends \Temando\Shipping\Rest\EntityMapper\FulfillmentResponseMapper implements \Magento\Framework\ObjectManager\NoninterceptableInterface
{
    /**
     * Object Manager instance
     *
     * @var \Magento\Framework\ObjectManagerInterface
     */
    protected $_objectManager = null;

    /**
     * Proxied instance name
     *
     * @var string
     */
    protected $_instanceName = null;

    /**
     * Proxied instance
     *
     * @var \Temando\Shipping\Rest\EntityMapper\FulfillmentResponseMapper
     */
    protected $_subject = null;

    /**
     * Instance shareability flag
     *
     * @var bool
     */
    protected $_isShared = null;

    /**
     * Proxy constructor
     *
     * @param \Magento\Framework\ObjectManagerInterface $objectManager
     * @param string $instanceName
     * @param bool $shared
     */
    public function __construct(\Magento\Framework\ObjectManagerInterface $objectManager, $instanceName = '\\Temando\\Shipping\\Rest\\EntityMapper\\FulfillmentResponseMapper', $shared = true)
    {
        $this->_objectManager = $objectManager;
        $this->_instanceName = $instanceName;
        $this->_isShared = $shared;
    }

    /**
     * @return array
     */
    public function __sleep()
    {
        return ['_subject', '_isShared', '_instanceName'];
    }

    /**
     * Retrieve ObjectManager from global scope
     */
    public function __wakeup()
    {
        $this->_objectManager = \Magento\Framework\App\ObjectManager::getInstance();
    }

    /**
     * Clone proxied instance
     */
    public function __clone()
    {
        $this->_subject = clone $this->_getSubject();
    }

    /**
     * Get proxied instance
     *
     * @return \Temando\Shipping\Rest\EntityMapper\FulfillmentResponseMapper
     */
    protected function _getSubject()
    {
        if (!$this->_subject) {
            $this->_subject = true === $this->_isShared
                ? $this->_objectManager->get($this->_instanceName)
                : $this->_objectManager->create($this->_instanceName);
        }
        return $this->_subject;
    }

    /**
     * {@inheritdoc}
     */
    public function mapPickup(\Temando\Shipping\Rest\Response\DataObject\Fulfillment $apiFulfillment)
    {
        return $this->_getSubject()->mapPickup($apiFulfillment);
    }

    /**
     * {@inheritdoc}
     */
    public function getPath($property)
    {
        return $this->_getSubject()->getPath($property);
    }
}
