<?php
namespace Plumrocket\Amp\Helper\Data;

/**
 * Proxy class for @see \Plumrocket\Amp\Helper\Data
 */
class Proxy extends \Plumrocket\Amp\Helper\Data implements \Magento\Framework\ObjectManager\NoninterceptableInterface
{
    /**
     * Object Manager instance
     *
     * @var \Magento\Framework\ObjectManagerInterface
     */
    protected $_objectManager = null;

    /**
     * Proxied instance name
     *
     * @var string
     */
    protected $_instanceName = null;

    /**
     * Proxied instance
     *
     * @var \Plumrocket\Amp\Helper\Data
     */
    protected $_subject = null;

    /**
     * Instance shareability flag
     *
     * @var bool
     */
    protected $_isShared = null;

    /**
     * Proxy constructor
     *
     * @param \Magento\Framework\ObjectManagerInterface $objectManager
     * @param string $instanceName
     * @param bool $shared
     */
    public function __construct(\Magento\Framework\ObjectManagerInterface $objectManager, $instanceName = '\\Plumrocket\\Amp\\Helper\\Data', $shared = true)
    {
        $this->_objectManager = $objectManager;
        $this->_instanceName = $instanceName;
        $this->_isShared = $shared;
    }

    /**
     * @return array
     */
    public function __sleep()
    {
        return ['_subject', '_isShared', '_instanceName'];
    }

    /**
     * Retrieve ObjectManager from global scope
     */
    public function __wakeup()
    {
        $this->_objectManager = \Magento\Framework\App\ObjectManager::getInstance();
    }

    /**
     * Clone proxied instance
     */
    public function __clone()
    {
        $this->_subject = clone $this->_getSubject();
    }

    /**
     * Get proxied instance
     *
     * @return \Plumrocket\Amp\Helper\Data
     */
    protected function _getSubject()
    {
        if (!$this->_subject) {
            $this->_subject = true === $this->_isShared
                ? $this->_objectManager->get($this->_instanceName)
                : $this->_objectManager->create($this->_instanceName);
        }
        return $this->_subject;
    }

    /**
     * {@inheritdoc}
     */
    public function getAllowedPages($store = null)
    {
        return $this->_getSubject()->getAllowedPages($store);
    }

    /**
     * {@inheritdoc}
     */
    public function isAllowedPage()
    {
        return $this->_getSubject()->isAllowedPage();
    }

    /**
     * {@inheritdoc}
     */
    public function isAllowedUrl()
    {
        return $this->_getSubject()->isAllowedUrl();
    }

    /**
     * {@inheritdoc}
     */
    public function getFullActionName()
    {
        return $this->_getSubject()->getFullActionName();
    }

    /**
     * {@inheritdoc}
     */
    public function isEsiRequest()
    {
        return $this->_getSubject()->isEsiRequest();
    }

    /**
     * {@inheritdoc}
     */
    public function isSearchEnabled()
    {
        return $this->_getSubject()->isSearchEnabled();
    }

    /**
     * {@inheritdoc}
     */
    public function moduleEnabled($store = null)
    {
        return $this->_getSubject()->moduleEnabled($store);
    }

    /**
     * {@inheritdoc}
     */
    public function forceOnMobile($store = null)
    {
        return $this->_getSubject()->forceOnMobile($store);
    }

    /**
     * {@inheritdoc}
     */
    public function forceOnTablet($store = null)
    {
        return $this->_getSubject()->forceOnTablet($store);
    }

    /**
     * {@inheritdoc}
     */
    public function canForce($store = null)
    {
        return $this->_getSubject()->canForce($store);
    }

    /**
     * {@inheritdoc}
     */
    public function isForceEnable($store = null)
    {
        return $this->_getSubject()->isForceEnable($store);
    }

    /**
     * {@inheritdoc}
     */
    public function isDisableAmpMode()
    {
        return $this->_getSubject()->isDisableAmpMode();
    }

    /**
     * {@inheritdoc}
     */
    public function redirectToAmpPageVersion($response = null)
    {
        return $this->_getSubject()->redirectToAmpPageVersion($response);
    }

    /**
     * {@inheritdoc}
     */
    public function isAmpRequest()
    {
        return $this->_getSubject()->isAmpRequest();
    }

    /**
     * {@inheritdoc}
     */
    public function isGoogleBot()
    {
        return $this->_getSubject()->isGoogleBot();
    }

    /**
     * {@inheritdoc}
     */
    public function isMobile()
    {
        return $this->_getSubject()->isMobile();
    }

    /**
     * {@inheritdoc}
     */
    public function isTablet()
    {
        return $this->_getSubject()->isTablet();
    }

    /**
     * {@inheritdoc}
     */
    public function setAmpRequest($value)
    {
        return $this->_getSubject()->setAmpRequest($value);
    }

    /**
     * {@inheritdoc}
     */
    public function isOnlyOptionsRequest()
    {
        return $this->_getSubject()->isOnlyOptionsRequest();
    }

    /**
     * {@inheritdoc}
     */
    public function isDisabledUrl()
    {
        return $this->_getSubject()->isDisabledUrl();
    }

    /**
     * {@inheritdoc}
     */
    public function getCanonicalUrl($url = null, $params = null)
    {
        return $this->_getSubject()->getCanonicalUrl($url, $params);
    }

    /**
     * {@inheritdoc}
     */
    public function disableExtension()
    {
        return $this->_getSubject()->disableExtension();
    }

    /**
     * {@inheritdoc}
     */
    public function getAmpUrl($url = null, $params = null, $excludedParams = null)
    {
        return $this->_getSubject()->getAmpUrl($url, $params, $excludedParams);
    }

    /**
     * {@inheritdoc}
     */
    public function getHtmlAmpUrl()
    {
        return $this->_getSubject()->getHtmlAmpUrl();
    }

    /**
     * {@inheritdoc}
     */
    public function getIframeSrc($product, $store = null)
    {
        return $this->_getSubject()->getIframeSrc($product, $store);
    }

    /**
     * {@inheritdoc}
     */
    public function getActionForReviewForm($productId)
    {
        return $this->_getSubject()->getActionForReviewForm($productId);
    }

    /**
     * {@inheritdoc}
     */
    public function getBaseUrl()
    {
        return $this->_getSubject()->getBaseUrl();
    }

    /**
     * {@inheritdoc}
     */
    public function removeSameOrigin()
    {
        return $this->_getSubject()->removeSameOrigin();
    }

    /**
     * {@inheritdoc}
     */
    public function sanitizeHttpHeaders()
    {
        return $this->_getSubject()->sanitizeHttpHeaders();
    }

    /**
     * {@inheritdoc}
     */
    public function setFormRedirectHeaders($url)
    {
        return $this->_getSubject()->setFormRedirectHeaders($url);
    }

    /**
     * {@inheritdoc}
     */
    public function getOnlyOptionsUrl($product)
    {
        return $this->_getSubject()->getOnlyOptionsUrl($product);
    }

    /**
     * {@inheritdoc}
     */
    public function getFormReturnUrl($url = null)
    {
        return $this->_getSubject()->getFormReturnUrl($url);
    }

    /**
     * {@inheritdoc}
     */
    public function getAccessControlOrigin()
    {
        return $this->_getSubject()->getAccessControlOrigin();
    }

    /**
     * {@inheritdoc}
     */
    public function isSecure()
    {
        return $this->_getSubject()->isSecure();
    }

    /**
     * {@inheritdoc}
     */
    public function isCookieRestrictionModeEnabled($store = null)
    {
        return $this->_getSubject()->isCookieRestrictionModeEnabled($store);
    }

    /**
     * {@inheritdoc}
     */
    public function getLogoWidth($store = null)
    {
        return $this->_getSubject()->getLogoWidth($store);
    }

    /**
     * {@inheritdoc}
     */
    public function getLogoHeight($store = null)
    {
        return $this->_getSubject()->getLogoHeight($store);
    }

    /**
     * {@inheritdoc}
     */
    public function getLogoSrc($store = null)
    {
        return $this->_getSubject()->getLogoSrc($store);
    }

    /**
     * {@inheritdoc}
     */
    public function getAmpIframePath($store = null)
    {
        return $this->_getSubject()->getAmpIframePath($store);
    }

    /**
     * {@inheritdoc}
     */
    public function getNavigationsTextColor($store = null)
    {
        return $this->_getSubject()->getNavigationsTextColor($store);
    }

    /**
     * {@inheritdoc}
     */
    public function getLinkColor($store = null)
    {
        return $this->_getSubject()->getLinkColor($store);
    }

    /**
     * {@inheritdoc}
     */
    public function getLinkColorHover($store = null)
    {
        return $this->_getSubject()->getLinkColorHover($store);
    }

    /**
     * {@inheritdoc}
     */
    public function getButtonBgColor($store = null)
    {
        return $this->_getSubject()->getButtonBgColor($store);
    }

    /**
     * {@inheritdoc}
     */
    public function getButtonBgColorHover($store = null)
    {
        return $this->_getSubject()->getButtonBgColorHover($store);
    }

    /**
     * {@inheritdoc}
     */
    public function getButtonTextColor($store = null)
    {
        return $this->_getSubject()->getButtonTextColor($store);
    }

    /**
     * {@inheritdoc}
     */
    public function isEnabledHeaderSearch($store = null)
    {
        return $this->_getSubject()->isEnabledHeaderSearch($store);
    }

    /**
     * {@inheritdoc}
     */
    public function getButtonTextColorHover($store = null)
    {
        return $this->_getSubject()->getButtonTextColorHover($store);
    }

    /**
     * {@inheritdoc}
     */
    public function getPriceTextColor($store = null)
    {
        return $this->_getSubject()->getPriceTextColor($store);
    }

    /**
     * {@inheritdoc}
     */
    public function getRtlEnabled($store = null)
    {
        return $this->_getSubject()->getRtlEnabled($store);
    }

    /**
     * {@inheritdoc}
     */
    public function getSocialSharingEnabled($store = null)
    {
        return $this->_getSubject()->getSocialSharingEnabled($store);
    }

    /**
     * {@inheritdoc}
     */
    public function getActiveShareButtons($store = null)
    {
        return $this->_getSubject()->getActiveShareButtons($store);
    }

    /**
     * {@inheritdoc}
     */
    public function getShareButtonFacebookAppID($store = null)
    {
        return $this->_getSubject()->getShareButtonFacebookAppID($store);
    }

    /**
     * {@inheritdoc}
     */
    public function getGoogleTagCode($store = null)
    {
        return $this->_getSubject()->getGoogleTagCode($store);
    }

    /**
     * {@inheritdoc}
     */
    public function getZopimEnabled($store = null)
    {
        return $this->_getSubject()->getZopimEnabled($store);
    }

    /**
     * {@inheritdoc}
     */
    public function getZopimDomain($store = null)
    {
        return $this->_getSubject()->getZopimDomain($store);
    }

    /**
     * {@inheritdoc}
     */
    public function getZopimKey($store = null)
    {
        return $this->_getSubject()->getZopimKey($store);
    }

    /**
     * {@inheritdoc}
     */
    public function getZopimButtonLabel($store = null)
    {
        return $this->_getSubject()->getZopimButtonLabel($store);
    }

    /**
     * {@inheritdoc}
     */
    public function getZopimButtonBgColor($store = null)
    {
        return $this->_getSubject()->getZopimButtonBgColor($store);
    }

    /**
     * {@inheritdoc}
     */
    public function getZopimButtonTextColor($store = null)
    {
        return $this->_getSubject()->getZopimButtonTextColor($store);
    }

    /**
     * {@inheritdoc}
     */
    public function getReviewsSummaryHtml(\Magento\Catalog\Model\Product $product, $templateType = false, $displayIfNoReviews = false)
    {
        return $this->_getSubject()->getReviewsSummaryHtml($product, $templateType, $displayIfNoReviews);
    }

    /**
     * {@inheritdoc}
     */
    public function removeRequestParam($url, $paramKey, $caseSensitive = false)
    {
        return $this->_getSubject()->removeRequestParam($url, $paramKey, $caseSensitive);
    }

    /**
     * {@inheritdoc}
     */
    public function getAjaxUrl($route, $params = [])
    {
        return $this->_getSubject()->getAjaxUrl($route, $params);
    }

    /**
     * {@inheritdoc}
     */
    public function __setOrder(\Magento\Sales\Model\Order $order)
    {
        return $this->_getSubject()->__setOrder($order);
    }

    /**
     * {@inheritdoc}
     */
    public function isMarketplace($customerKey)
    {
        return $this->_getSubject()->isMarketplace($customerKey);
    }

    /**
     * {@inheritdoc}
     */
    public function preparedData()
    {
        return $this->_getSubject()->preparedData();
    }

    /**
     * {@inheritdoc}
     */
    public function getConfigSectionId()
    {
        return $this->_getSubject()->getConfigSectionId();
    }

    /**
     * {@inheritdoc}
     */
    public function getConfig($path, $store = null, $scope = null)
    {
        return $this->_getSubject()->getConfig($path, $store, $scope);
    }

    /**
     * {@inheritdoc}
     */
    public function moduleExists($moduleName)
    {
        return $this->_getSubject()->moduleExists($moduleName);
    }

    /**
     * {@inheritdoc}
     */
    public function getModuleStatus(string $moduleName)
    {
        return $this->_getSubject()->getModuleStatus($moduleName);
    }

    /**
     * {@inheritdoc}
     */
    public function getModuleHelper($moduleName)
    {
        return $this->_getSubject()->getModuleHelper($moduleName);
    }

    /**
     * {@inheritdoc}
     */
    public function getConfigHelper(string $moduleName)
    {
        return $this->_getSubject()->getConfigHelper($moduleName);
    }

    /**
     * {@inheritdoc}
     */
    public function getMagento2Version()
    {
        return $this->_getSubject()->getMagento2Version();
    }

    /**
     * {@inheritdoc}
     */
    public function isModuleOutputEnabled($moduleName = null)
    {
        return $this->_getSubject()->isModuleOutputEnabled($moduleName);
    }
}
