<?php

namespace Yotpo\Yotpo\Block;
use Magento\Store\Model\ScopeInterface;
class Config
{
    const YOTPO_APP_KEY = 'yotpo/settings/app_key';
    const YOTPO_SECRET = 'yotpo/settings/secret';
    const YOTPO_WIDGET_ENABLED = 'yotpo/settings/widget_enabled';
    const YOTPO_BOTTOMLINE_ENABLED = 'yotpo/settings/bottomline_enabled';
    const YOTPO_BOTTOMLINE_QNA_ENABLED = 'yotpo/settings/qna_enabled';
    
    const YOTPO_CUSTOM_ORDER_STATUS = 'yotpo/settings/custom_order_status';

    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
    ) {        
        $this->_scopeConfig = $scopeConfig;
    }

    public function getAppKey($storeId = null)
    {   
        return $this->_scopeConfig->getValue(self::YOTPO_APP_KEY, ScopeInterface::SCOPE_STORE, $storeId);
    }

    public function getSecret($storeId = null)
    {        
        return $this->_scopeConfig->getValue(self::YOTPO_SECRET, ScopeInterface::SCOPE_STORE, $storeId);
    }

    public function getCostumeOrderStatus()
    {
        null;
    }

    public function getCustomOrderStatus($storeId = null)
    {
        return $this->_scopeConfig->getValue(self::YOTPO_CUSTOM_ORDER_STATUS, ScopeInterface::SCOPE_STORE, $storeId);
    }

    public function isWidgetEnabled()
    {        
        return (bool)$this->_scopeConfig->getValue(self::YOTPO_WIDGET_ENABLED, ScopeInterface::SCOPE_STORE);
    } 

    public function isBottomlineEnabled()
    {        
        return (bool)$this->_scopeConfig->getValue(self::YOTPO_BOTTOMLINE_ENABLED, ScopeInterface::SCOPE_STORE);
    } 
    
    public function isBottomlineQnaEnabled()
    {        
        return (bool)$this->_scopeConfig->getValue(self::YOTPO_BOTTOMLINE_QNA_ENABLED, ScopeInterface::SCOPE_STORE);
    } 

    public function isAppKeyAndSecretSet($storeId = null)
    {        
        return ($this->getAppKey($storeId) != null && $this->getSecret($storeId) != null);
    } 

    public function getTimeFrame()
    {        
        $today = time();
        $last = $today - (60*60*24*90); //90 days ago
        return date("Y-m-d", $last);
    }              
}
